@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains FQDN of the DNS record associated with the public IP address.
 * @property domainNameLabel The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
 * @property domainNameLabelScope The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN.
 * @property fqdn The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
 * @property reverseFqdn The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
 */
public data class PublicIPAddressDnsSettingsResponse(
    public val domainNameLabel: String? = null,
    public val domainNameLabelScope: String? = null,
    public val fqdn: String? = null,
    public val reverseFqdn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PublicIPAddressDnsSettingsResponse): PublicIPAddressDnsSettingsResponse = PublicIPAddressDnsSettingsResponse(
            domainNameLabel = javaType.domainNameLabel().map({ args0 -> args0 }).orElse(null),
            domainNameLabelScope = javaType.domainNameLabelScope().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            reverseFqdn = javaType.reverseFqdn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
