@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Radius Server Settings.
 * @property radiusServerAddress The address of this radius server.
 * @property radiusServerScore The initial score assigned to this radius server.
 * @property radiusServerSecret The secret used for this radius server.
 */
public data class RadiusServerResponse(
    public val radiusServerAddress: String,
    public val radiusServerScore: Double? = null,
    public val radiusServerSecret: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RadiusServerResponse): RadiusServerResponse = RadiusServerResponse(
            radiusServerAddress = javaType.radiusServerAddress(),
            radiusServerScore = javaType.radiusServerScore().map({ args0 -> args0 }).orElse(null),
            radiusServerSecret = javaType.radiusServerSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
