@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes Redirect Route.
 * @property customFragment Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
 * @property customHost Host to redirect. Leave empty to use the incoming host as the destination host.
 * @property customPath The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
 * @property customQueryString The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
 * @property odataType
 * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
 * @property redirectProtocol The protocol of the destination to where the traffic is redirected
 * @property redirectType The redirect type the rule will use when redirecting traffic.
 */
public data class RedirectConfigurationResponse(
    public val customFragment: String? = null,
    public val customHost: String? = null,
    public val customPath: String? = null,
    public val customQueryString: String? = null,
    public val odataType: String,
    public val redirectProtocol: String? = null,
    public val redirectType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RedirectConfigurationResponse): RedirectConfigurationResponse = RedirectConfigurationResponse(
            customFragment = javaType.customFragment().map({ args0 -> args0 }).orElse(null),
            customHost = javaType.customHost().map({ args0 -> args0 }).orElse(null),
            customPath = javaType.customPath().map({ args0 -> args0 }).orElse(null),
            customQueryString = javaType.customQueryString().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            redirectProtocol = javaType.redirectProtocol().map({ args0 -> args0 }).orElse(null),
            redirectType = javaType.redirectType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
