@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Parameters that define the retention policy for flow log.
 * @property days Number of days to retain flow log records.
 * @property enabled Flag to enable/disable retention.
 */
public data class RetentionPolicyParametersResponse(
    public val days: Int? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RetentionPolicyParametersResponse): RetentionPolicyParametersResponse = RetentionPolicyParametersResponse(
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
