@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Route Filter Rule Resource.
 * @property access The access type of the rule.
 * @property communities The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the route filter rule resource.
 * @property routeFilterRuleType The rule type of the rule.
 */
public data class RouteFilterRuleResponse(
    public val access: String,
    public val communities: List<String>,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val routeFilterRuleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RouteFilterRuleResponse): RouteFilterRuleResponse = RouteFilterRuleResponse(
            access = javaType.access(),
            communities = javaType.communities().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routeFilterRuleType = javaType.routeFilterRuleType(),
        )
    }
}
