@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A RouteMap Rule.
 * @property actions List of actions which will be applied on a match.
 * @property matchCriteria List of matching criterion which will be applied to traffic.
 * @property name The unique name for the rule.
 * @property nextStepIfMatched Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
 */
public data class RouteMapRuleResponse(
    public val actions: List<ActionResponse>? = null,
    public val matchCriteria: List<CriterionResponse>? = null,
    public val name: String? = null,
    public val nextStepIfMatched: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RouteMapRuleResponse): RouteMapRuleResponse = RouteMapRuleResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ActionResponse.Companion.toKotlin(args0)
                })
            }),
            matchCriteria = javaType.matchCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.CriterionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nextStepIfMatched = javaType.nextStepIfMatched().map({ args0 -> args0 }).orElse(null),
        )
    }
}
