@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Route resource.
 * @property addressPrefix The destination CIDR to which the route applies.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hasBgpOverride A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property nextHopIpAddress The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 * @property nextHopType The type of Azure hop the packet should be sent to.
 * @property provisioningState The provisioning state of the route resource.
 * @property type The type of the resource.
 */
public data class RouteResponse(
    public val addressPrefix: String? = null,
    public val etag: String,
    public val hasBgpOverride: Boolean? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val nextHopIpAddress: String? = null,
    public val nextHopType: String,
    public val provisioningState: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RouteResponse): RouteResponse = RouteResponse(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            hasBgpOverride = javaType.hasBgpOverride().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nextHopIpAddress = javaType.nextHopIpAddress().map({ args0 -> args0 }).orElse(null),
            nextHopType = javaType.nextHopType(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
