@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The routing policy object used in a RoutingIntent resource.
 * @property destinations List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
 * @property name The unique name for the routing policy.
 * @property nextHop The next hop resource id on which this routing policy is applicable to.
 */
public data class RoutingPolicyResponse(
    public val destinations: List<String>,
    public val name: String,
    public val nextHop: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RoutingPolicyResponse): RoutingPolicyResponse = RoutingPolicyResponse(
            destinations = javaType.destinations().map({ args0 -> args0 }),
            name = javaType.name(),
            nextHop = javaType.nextHop(),
        )
    }
}
