@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
 * @property acceptedProtocols Protocol schemes to match for this rule
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property frontendEndpoints Frontend endpoints associated with this rule
 * @property id Resource ID.
 * @property name Resource name.
 * @property patternsToMatch The route patterns of the rule.
 * @property resourceState Resource status.
 * @property routeConfiguration A reference to the routing configuration.
 * @property rulesEngine A reference to a specific Rules Engine Configuration to apply to this route.
 * @property type Resource type.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for each routing rule (if applicable)
 */
public data class RoutingRuleResponse(
    public val acceptedProtocols: List<String>? = null,
    public val enabledState: String? = null,
    public val frontendEndpoints: List<SubResourceResponse>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val patternsToMatch: List<String>? = null,
    public val resourceState: String,
    public val routeConfiguration: Either<ForwardingConfigurationResponse, RedirectConfigurationResponse>? = null,
    public val rulesEngine: SubResourceResponse? = null,
    public val type: String,
    public val webApplicationFirewallPolicyLink: RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RoutingRuleResponse): RoutingRuleResponse = RoutingRuleResponse(
            acceptedProtocols = javaType.acceptedProtocols().map({ args0 -> args0 }),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            frontendEndpoints = javaType.frontendEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            patternsToMatch = javaType.patternsToMatch().map({ args0 -> args0 }),
            resourceState = javaType.resourceState(),
            routeConfiguration = javaType.routeConfiguration().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.ForwardingConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.RedirectConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            rulesEngine = javaType.rulesEngine().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            webApplicationFirewallPolicyLink = javaType.webApplicationFirewallPolicyLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
