@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Suppress
import kotlin.collections.List

/**
 * One or more actions that will execute, modifying the request and/or response.
 * @property requestHeaderActions A list of header actions to apply from the request from AFD to the origin.
 * @property responseHeaderActions A list of header actions to apply from the response from AFD to the client.
 * @property routeConfigurationOverride Override the route configuration.
 */
public data class RulesEngineActionResponse(
    public val requestHeaderActions: List<HeaderActionResponse>? = null,
    public val responseHeaderActions: List<HeaderActionResponse>? = null,
    public val routeConfigurationOverride: Either<ForwardingConfigurationResponse, RedirectConfigurationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RulesEngineActionResponse): RulesEngineActionResponse = RulesEngineActionResponse(
            requestHeaderActions = javaType.requestHeaderActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HeaderActionResponse.Companion.toKotlin(args0)
                })
            }),
            responseHeaderActions = javaType.responseHeaderActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HeaderActionResponse.Companion.toKotlin(args0)
                })
            }),
            routeConfigurationOverride = javaType.routeConfigurationOverride().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.ForwardingConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.RedirectConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
        )
    }
}
