@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define a match condition
 * @property negateCondition Describes if this is negate condition or not
 * @property rulesEngineMatchValue Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
 * @property rulesEngineMatchVariable Match Variable
 * @property rulesEngineOperator Describes operator to apply to the match condition.
 * @property selector Name of selector in RequestHeader or RequestBody to be matched
 * @property transforms List of transforms
 */
public data class RulesEngineMatchConditionResponse(
    public val negateCondition: Boolean? = null,
    public val rulesEngineMatchValue: List<String>,
    public val rulesEngineMatchVariable: String,
    public val rulesEngineOperator: String,
    public val selector: String? = null,
    public val transforms: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RulesEngineMatchConditionResponse): RulesEngineMatchConditionResponse = RulesEngineMatchConditionResponse(
            negateCondition = javaType.negateCondition().map({ args0 -> args0 }).orElse(null),
            rulesEngineMatchValue = javaType.rulesEngineMatchValue().map({ args0 -> args0 }),
            rulesEngineMatchVariable = javaType.rulesEngineMatchVariable(),
            rulesEngineOperator = javaType.rulesEngineOperator(),
            selector = javaType.selector().map({ args0 -> args0 }).orElse(null),
            transforms = javaType.transforms().map({ args0 -> args0 }),
        )
    }
}
