@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
 * @property id Resource ID.
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property rules A list of rules that define a particular Rules Engine Configuration.
 * @property type Resource type.
 */
public data class RulesEngineResponse(
    public val id: String,
    public val name: String,
    public val resourceState: String,
    public val rules: List<RulesEngineRuleResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RulesEngineResponse): RulesEngineResponse = RulesEngineResponse(
            id = javaType.id(),
            name = javaType.name(),
            resourceState = javaType.resourceState(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RulesEngineRuleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
