@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
 * @property action Actions to perform on the request and response if all of the match conditions are met.
 * @property matchConditions A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
 * @property matchProcessingBehavior If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
 * @property name A name to refer to this specific rule.
 * @property priority A priority assigned to this rule.
 */
public data class RulesEngineRuleResponse(
    public val action: RulesEngineActionResponse,
    public val matchConditions: List<RulesEngineMatchConditionResponse>? = null,
    public val matchProcessingBehavior: String? = null,
    public val name: String,
    public val priority: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RulesEngineRuleResponse): RulesEngineRuleResponse = RulesEngineRuleResponse(
            action = javaType.action().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.RulesEngineActionResponse.Companion.toKotlin(args0)
            }),
            matchConditions = javaType.matchConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RulesEngineMatchConditionResponse.Companion.toKotlin(args0)
                })
            }),
            matchProcessingBehavior = javaType.matchProcessingBehavior().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            priority = javaType.priority(),
        )
    }
}
