@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ServiceAssociationLink resource.
 * @property allowDelete If true, the resource can be deleted.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property link Link to the external resource.
 * @property linkedResourceType Resource type of the linked resource.
 * @property locations A list of locations.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the service association link resource.
 * @property type Resource type.
 */
public data class ServiceAssociationLinkResponse(
    public val allowDelete: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val link: String? = null,
    public val linkedResourceType: String? = null,
    public val locations: List<String>? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ServiceAssociationLinkResponse): ServiceAssociationLinkResponse = ServiceAssociationLinkResponse(
            allowDelete = javaType.allowDelete().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            link = javaType.link().map({ args0 -> args0 }).orElse(null),
            linkedResourceType = javaType.linkedResourceType().map({ args0 -> args0 }).orElse(null),
            locations = javaType.locations().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
