@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The service endpoint properties.
 * @property locations A list of locations.
 * @property provisioningState The provisioning state of the service endpoint resource.
 * @property service The type of the endpoint service.
 */
public data class ServiceEndpointPropertiesFormatResponse(
    public val locations: List<String>? = null,
    public val provisioningState: String,
    public val service: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ServiceEndpointPropertiesFormatResponse): ServiceEndpointPropertiesFormatResponse = ServiceEndpointPropertiesFormatResponse(
            locations = javaType.locations().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            service = javaType.service().map({ args0 -> args0 }).orElse(null),
        )
    }
}
