@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * An SOA record.
 * @property email The email contact for this SOA record.
 * @property expireTime The expire time for this SOA record.
 * @property host The domain name of the authoritative name server for this SOA record.
 * @property minimumTtl The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
 * @property refreshTime The refresh value for this SOA record.
 * @property retryTime The retry time for this SOA record.
 * @property serialNumber The serial number for this SOA record.
 */
public data class SoaRecordResponse(
    public val email: String? = null,
    public val expireTime: Double? = null,
    public val host: String? = null,
    public val minimumTtl: Double? = null,
    public val refreshTime: Double? = null,
    public val retryTime: Double? = null,
    public val serialNumber: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.SoaRecordResponse): SoaRecordResponse = SoaRecordResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            expireTime = javaType.expireTime().map({ args0 -> args0 }).orElse(null),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            minimumTtl = javaType.minimumTtl().map({ args0 -> args0 }).orElse(null),
            refreshTime = javaType.refreshTime().map({ args0 -> args0 }).orElse(null),
            retryTime = javaType.retryTime().map({ args0 -> args0 }).orElse(null),
            serialNumber = javaType.serialNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
