@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An SRV record.
 * @property port The port value for this SRV record.
 * @property priority The priority value for this SRV record.
 * @property target The target domain name for this SRV record.
 * @property weight The weight value for this SRV record.
 */
public data class SrvRecordResponse(
    public val port: Int? = null,
    public val priority: Int? = null,
    public val target: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.SrvRecordResponse): SrvRecordResponse = SrvRecordResponse(
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
