@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of all Static Routes.
 * @property addressPrefixes List of all address prefixes.
 * @property name The name of the StaticRoute that is unique within a VnetRoute.
 * @property nextHopIpAddress The ip address of the next hop.
 */
public data class StaticRouteResponse(
    public val addressPrefixes: List<String>? = null,
    public val name: String? = null,
    public val nextHopIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.StaticRouteResponse): StaticRouteResponse = StaticRouteResponse(
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nextHopIpAddress = javaType.nextHopIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
