@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a server to forward the DNS queries to.
 * @property ipAddress DNS server IP address.
 * @property port DNS server port.
 */
public data class TargetDnsServerResponse(
    public val ipAddress: String,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.TargetDnsServerResponse): TargetDnsServerResponse = TargetDnsServerResponse(
            ipAddress = javaType.ipAddress(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
