@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An traffic selector policy for a virtual network gateway connection.
 * @property localAddressRanges A collection of local address spaces in CIDR format.
 * @property remoteAddressRanges A collection of remote address spaces in CIDR format.
 */
public data class TrafficSelectorPolicyResponse(
    public val localAddressRanges: List<String>,
    public val remoteAddressRanges: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.TrafficSelectorPolicyResponse): TrafficSelectorPolicyResponse = TrafficSelectorPolicyResponse(
            localAddressRanges = javaType.localAddressRanges().map({ args0 -> args0 }),
            remoteAddressRanges = javaType.remoteAddressRanges().map({ args0 -> args0 }),
        )
    }
}
