@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * VirtualNetworkGatewayConnection properties.
 * @property connectionStatus Virtual Network Gateway connection status.
 * @property egressBytesTransferred The Egress Bytes Transferred in this connection.
 * @property ingressBytesTransferred The Ingress Bytes Transferred in this connection.
 * @property lastConnectionEstablishedUtcTime The time at which connection was established in Utc format.
 * @property tunnel Tunnel name.
 */
public data class TunnelConnectionHealthResponse(
    public val connectionStatus: String,
    public val egressBytesTransferred: Double,
    public val ingressBytesTransferred: Double,
    public val lastConnectionEstablishedUtcTime: String,
    public val tunnel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.TunnelConnectionHealthResponse): TunnelConnectionHealthResponse = TunnelConnectionHealthResponse(
            connectionStatus = javaType.connectionStatus(),
            egressBytesTransferred = javaType.egressBytesTransferred(),
            ingressBytesTransferred = javaType.ingressBytesTransferred(),
            lastConnectionEstablishedUtcTime = javaType.lastConnectionEstablishedUtcTime(),
            tunnel = javaType.tunnel(),
        )
    }
}
