@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network Virtual Appliance Sku Properties.
 * @property bundledScaleUnit Virtual Appliance Scale Unit.
 * @property marketPlaceVersion Virtual Appliance Version.
 * @property vendor Virtual Appliance Vendor.
 */
public data class VirtualApplianceSkuPropertiesResponse(
    public val bundledScaleUnit: String? = null,
    public val marketPlaceVersion: String? = null,
    public val vendor: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualApplianceSkuPropertiesResponse): VirtualApplianceSkuPropertiesResponse = VirtualApplianceSkuPropertiesResponse(
            bundledScaleUnit = javaType.bundledScaleUnit().map({ args0 -> args0 }).orElse(null),
            marketPlaceVersion = javaType.marketPlaceVersion().map({ args0 -> args0 }).orElse(null),
            vendor = javaType.vendor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
