@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP configuration for virtual network gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateIPAddress Private IP Address for this gateway.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property provisioningState The provisioning state of the virtual network gateway IP configuration resource.
 * @property publicIPAddress The reference to the public IP resource.
 * @property subnet The reference to the subnet resource.
 */
public data class VirtualNetworkGatewayIPConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateIPAddress: String,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val publicIPAddress: SubResourceResponse? = null,
    public val subnet: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkGatewayIPConfigurationResponse): VirtualNetworkGatewayIPConfigurationResponse = VirtualNetworkGatewayIPConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress(),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
