@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * VirtualNetworkGatewaySku details.
 * @property capacity The capacity.
 * @property name Gateway SKU name.
 * @property tier Gateway SKU tier.
 */
public data class VirtualNetworkGatewaySkuResponse(
    public val capacity: Int,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkGatewaySkuResponse): VirtualNetworkGatewaySkuResponse = VirtualNetworkGatewaySkuResponse(
            capacity = javaType.capacity(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
