@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Virtual Network Tap resource.
 * @property destinationLoadBalancerFrontEndIPConfiguration The reference to the private IP address on the internal Load Balancer that will receive the tap.
 * @property destinationNetworkInterfaceIPConfiguration The reference to the private IP Address of the collector nic that will receive the tap.
 * @property destinationPort The VXLAN destination port that will receive the tapped traffic.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkInterfaceTapConfigurations Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
 * @property provisioningState The provisioning state of the virtual network tap resource.
 * @property resourceGuid The resource GUID property of the virtual network tap resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class VirtualNetworkTapResponse(
    public val destinationLoadBalancerFrontEndIPConfiguration: FrontendIPConfigurationResponse? =
        null,
    public val destinationNetworkInterfaceIPConfiguration: NetworkInterfaceIPConfigurationResponse? =
        null,
    public val destinationPort: Int? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val networkInterfaceTapConfigurations: List<NetworkInterfaceTapConfigurationResponse>,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkTapResponse): VirtualNetworkTapResponse = VirtualNetworkTapResponse(
            destinationLoadBalancerFrontEndIPConfiguration = javaType.destinationLoadBalancerFrontEndIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            destinationNetworkInterfaceIPConfiguration = javaType.destinationNetworkInterfaceIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            destinationPort = javaType.destinationPort().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterfaceTapConfigurations = javaType.networkInterfaceTapConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
