@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The VirtualHub Router autoscale configuration.
 * @property minCapacity The minimum number of scale units for VirtualHub Router.
 */
public data class VirtualRouterAutoScaleConfigurationResponse(
    public val minCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualRouterAutoScaleConfigurationResponse): VirtualRouterAutoScaleConfigurationResponse = VirtualRouterAutoScaleConfigurationResponse(
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
