@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A vpn client connection configuration for client connection configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the VngClientConnectionConfiguration resource.
 * @property virtualNetworkGatewayPolicyGroups List of references to virtualNetworkGatewayPolicyGroups
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 */
public data class VngClientConnectionConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val virtualNetworkGatewayPolicyGroups: List<SubResourceResponse>,
    public val vpnClientAddressPool: AddressSpaceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VngClientConnectionConfigurationResponse): VngClientConnectionConfigurationResponse = VngClientConnectionConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            virtualNetworkGatewayPolicyGroups = javaType.virtualNetworkGatewayPolicyGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientAddressPool = javaType.vpnClientAddressPool().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
