@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnClientConfiguration for P2S client.
 * @property aadAudience The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadIssuer The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadTenant The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property radiusServerAddress The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServerSecret The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServers The radiusServers property for multiple radius server configuration.
 * @property vngClientConnectionConfigurations per ip address pool connection policy for virtual network gateway P2S client.
 * @property vpnAuthenticationTypes VPN authentication types for the virtual network gateway..
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for virtual network gateway P2S client.
 * @property vpnClientProtocols VpnClientProtocols for Virtual network gateway.
 * @property vpnClientRevokedCertificates VpnClientRevokedCertificate for Virtual network gateway.
 * @property vpnClientRootCertificates VpnClientRootCertificate for virtual network gateway.
 */
public data class VpnClientConfigurationResponse(
    public val aadAudience: String? = null,
    public val aadIssuer: String? = null,
    public val aadTenant: String? = null,
    public val radiusServerAddress: String? = null,
    public val radiusServerSecret: String? = null,
    public val radiusServers: List<RadiusServerResponse>? = null,
    public val vngClientConnectionConfigurations: List<VngClientConnectionConfigurationResponse>? =
        null,
    public val vpnAuthenticationTypes: List<String>? = null,
    public val vpnClientAddressPool: AddressSpaceResponse? = null,
    public val vpnClientIpsecPolicies: List<IpsecPolicyResponse>? = null,
    public val vpnClientProtocols: List<String>? = null,
    public val vpnClientRevokedCertificates: List<VpnClientRevokedCertificateResponse>? = null,
    public val vpnClientRootCertificates: List<VpnClientRootCertificateResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnClientConfigurationResponse): VpnClientConfigurationResponse = VpnClientConfigurationResponse(
            aadAudience = javaType.aadAudience().map({ args0 -> args0 }).orElse(null),
            aadIssuer = javaType.aadIssuer().map({ args0 -> args0 }).orElse(null),
            aadTenant = javaType.aadTenant().map({ args0 -> args0 }).orElse(null),
            radiusServerAddress = javaType.radiusServerAddress().map({ args0 -> args0 }).orElse(null),
            radiusServerSecret = javaType.radiusServerSecret().map({ args0 -> args0 }).orElse(null),
            radiusServers = javaType.radiusServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RadiusServerResponse.Companion.toKotlin(args0)
                })
            }),
            vngClientConnectionConfigurations = javaType.vngClientConnectionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VngClientConnectionConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            vpnAuthenticationTypes = javaType.vpnAuthenticationTypes().map({ args0 -> args0 }),
            vpnClientAddressPool = javaType.vpnClientAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnClientIpsecPolicies = javaType.vpnClientIpsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientProtocols = javaType.vpnClientProtocols().map({ args0 -> args0 }),
            vpnClientRevokedCertificates = javaType.vpnClientRevokedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnClientRevokedCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientRootCertificates = javaType.vpnClientRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnClientRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
