@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * VPN client connection health detail.
 * @property egressBytesTransferred The egress bytes per second.
 * @property egressPacketsTransferred The egress packets per second.
 * @property ingressBytesTransferred The ingress bytes per second.
 * @property ingressPacketsTransferred The ingress packets per second.
 * @property maxBandwidth The max band width.
 * @property maxPacketsPerSecond The max packets transferred per second.
 * @property privateIpAddress The assigned private Ip of a connected vpn client.
 * @property publicIpAddress The public Ip of a connected vpn client.
 * @property vpnConnectionDuration The duration time of a connected vpn client.
 * @property vpnConnectionId The vpn client Id.
 * @property vpnConnectionTime The start time of a connected vpn client.
 * @property vpnUserName The user name of a connected vpn client.
 */
public data class VpnClientConnectionHealthDetailResponse(
    public val egressBytesTransferred: Double,
    public val egressPacketsTransferred: Double,
    public val ingressBytesTransferred: Double,
    public val ingressPacketsTransferred: Double,
    public val maxBandwidth: Double,
    public val maxPacketsPerSecond: Double,
    public val privateIpAddress: String,
    public val publicIpAddress: String,
    public val vpnConnectionDuration: Double,
    public val vpnConnectionId: String,
    public val vpnConnectionTime: String,
    public val vpnUserName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnClientConnectionHealthDetailResponse): VpnClientConnectionHealthDetailResponse = VpnClientConnectionHealthDetailResponse(
            egressBytesTransferred = javaType.egressBytesTransferred(),
            egressPacketsTransferred = javaType.egressPacketsTransferred(),
            ingressBytesTransferred = javaType.ingressBytesTransferred(),
            ingressPacketsTransferred = javaType.ingressPacketsTransferred(),
            maxBandwidth = javaType.maxBandwidth(),
            maxPacketsPerSecond = javaType.maxPacketsPerSecond(),
            privateIpAddress = javaType.privateIpAddress(),
            publicIpAddress = javaType.publicIpAddress(),
            vpnConnectionDuration = javaType.vpnConnectionDuration(),
            vpnConnectionId = javaType.vpnConnectionId(),
            vpnConnectionTime = javaType.vpnConnectionTime(),
            vpnUserName = javaType.vpnUserName(),
        )
    }
}
