@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VPN client revoked certificate of virtual network gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the VPN client revoked certificate resource.
 * @property thumbprint The revoked VPN client certificate thumbprint.
 */
public data class VpnClientRevokedCertificateResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnClientRevokedCertificateResponse): VpnClientRevokedCertificateResponse = VpnClientRevokedCertificateResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
