@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * BGP settings details for a link.
 * @property asn The BGP speaker's ASN.
 * @property bgpPeeringAddress The BGP peering address and BGP identifier of this BGP speaker.
 */
public data class VpnLinkBgpSettingsResponse(
    public val asn: Double? = null,
    public val bgpPeeringAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnLinkBgpSettingsResponse): VpnLinkBgpSettingsResponse = VpnLinkBgpSettingsResponse(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            bgpPeeringAddress = javaType.bgpPeeringAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
