@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * List of properties of a link provider.
 * @property linkProviderName Name of the link provider.
 * @property linkSpeedInMbps Link speed.
 */
public data class VpnLinkProviderPropertiesResponse(
    public val linkProviderName: String? = null,
    public val linkSpeedInMbps: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnLinkProviderPropertiesResponse): VpnLinkProviderPropertiesResponse = VpnLinkProviderPropertiesResponse(
            linkProviderName = javaType.linkProviderName().map({ args0 -> args0 }).orElse(null),
            linkSpeedInMbps = javaType.linkSpeedInMbps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
