@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the Radius client root certificate of VpnServerConfiguration.
 * @property name The certificate name.
 * @property thumbprint The Radius client root certificate thumbprint.
 */
public data class VpnServerConfigRadiusClientRootCertificateResponse(
    public val name: String? = null,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnServerConfigRadiusClientRootCertificateResponse): VpnServerConfigRadiusClientRootCertificateResponse =
            VpnServerConfigRadiusClientRootCertificateResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
            )
    }
}
