@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin

import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ConsumptionEndpointsPropertiesResponse
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.DataProductNetworkAclsResponse
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.EncryptionKeyDetailsResponse
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ConsumptionEndpointsPropertiesResponse.Companion.toKotlin as consumptionEndpointsPropertiesResponseToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.DataProductNetworkAclsResponse.Companion.toKotlin as dataProductNetworkAclsResponseToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.EncryptionKeyDetailsResponse.Companion.toKotlin as encryptionKeyDetailsResponseToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataProduct].
 */
@PulumiTagMarker
public class DataProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataProductArgs = DataProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataProductArgsBuilder.() -> Unit) {
        val builder = DataProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataProduct {
        val builtJavaResource =
            com.pulumi.azurenative.networkanalytics.DataProduct(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataProduct(builtJavaResource)
    }
}

/**
 * The data product resource.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### DataProducts_Create_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataProduct = new AzureNative.NetworkAnalytics.DataProduct("dataProduct", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         Location = "eastus",
 *         MajorVersion = "1.0.0",
 *         Product = "MCC",
 *         Publisher = "Microsoft",
 *         ResourceGroupName = "aoiresourceGroupName",
 *         Tags =
 *         {
 *             { "userSpecifiedKeyName", "userSpecifiedKeyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataProduct(ctx, "dataProduct", &networkanalytics.DataProductArgs{
 * 			DataProductName:   pulumi.String("dataproduct01"),
 * 			Location:          pulumi.String("eastus"),
 * 			MajorVersion:      pulumi.String("1.0.0"),
 * 			Product:           pulumi.String("MCC"),
 * 			Publisher:         pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("aoiresourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"userSpecifiedKeyName": pulumi.String("userSpecifiedKeyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataProduct;
 * import com.pulumi.azurenative.networkanalytics.DataProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataProduct = new DataProduct("dataProduct", DataProductArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .location("eastus")
 *             .majorVersion("1.0.0")
 *             .product("MCC")
 *             .publisher("Microsoft")
 *             .resourceGroupName("aoiresourceGroupName")
 *             .tags(Map.of("userSpecifiedKeyName", "userSpecifiedKeyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkanalytics:DataProduct dataproduct01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}
 * ```
 */
public class DataProduct internal constructor(
    override val javaResource: com.pulumi.azurenative.networkanalytics.DataProduct,
) : KotlinCustomResource(javaResource, DataProductMapper) {
    /**
     * List of available minor versions of the data product resource.
     */
    public val availableMinorVersions: Output<List<String>>
        get() = javaResource.availableMinorVersions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource links which exposed to the customer to query the data.
     */
    public val consumptionEndpoints: Output<ConsumptionEndpointsPropertiesResponse>
        get() = javaResource.consumptionEndpoints().applyValue({ args0 ->
            args0.let({ args0 ->
                consumptionEndpointsPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Current configured minor version of the data product resource.
     */
    public val currentMinorVersion: Output<String>?
        get() = javaResource.currentMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Customer managed encryption key details for data product.
     */
    public val customerEncryptionKey: Output<EncryptionKeyDetailsResponse>?
        get() = javaResource.customerEncryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> encryptionKeyDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Flag to enable customer managed key encryption for data product.
     */
    public val customerManagedKeyEncryptionEnabled: Output<String>?
        get() = javaResource.customerManagedKeyEncryptionEnabled().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Documentation link for the data product based on definition file.
     */
    public val documentation: Output<String>
        get() = javaResource.documentation().applyValue({ args0 -> args0 })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key vault url.
     */
    public val keyVaultUrl: Output<String>
        get() = javaResource.keyVaultUrl().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Major version of data product.
     */
    public val majorVersion: Output<String>
        get() = javaResource.majorVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network rule set for data product.
     */
    public val networkacls: Output<DataProductNetworkAclsResponse>?
        get() = javaResource.networkacls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataProductNetworkAclsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of name or email associated with data product resource deployment.
     */
    public val owners: Output<List<String>>?
        get() = javaResource.owners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Flag to enable or disable private link for data product resource.
     */
    public val privateLinksEnabled: Output<String>?
        get() = javaResource.privateLinksEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Product name of data product.
     */
    public val product: Output<String>
        get() = javaResource.product().applyValue({ args0 -> args0 })

    /**
     * Latest provisioning state  of data product.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Flag to enable or disable public access of data product resource.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Data product publisher name.
     */
    public val publisher: Output<String>
        get() = javaResource.publisher().applyValue({ args0 -> args0 })

    /**
     * Purview account url for data product to connect to.
     */
    public val purviewAccount: Output<String>?
        get() = javaResource.purviewAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purview collection url for data product to connect to.
     */
    public val purviewCollection: Output<String>?
        get() = javaResource.purviewCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to enable or disable redundancy for data product.
     */
    public val redundancy: Output<String>?
        get() = javaResource.redundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource GUID property of the data product resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataProductMapper : ResourceMapper<DataProduct> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkanalytics.DataProduct::class == javaResource::class

    override fun map(javaResource: Resource): DataProduct = DataProduct(
        javaResource as
            com.pulumi.azurenative.networkanalytics.DataProduct,
    )
}

/**
 * @see [DataProduct].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataProduct].
 */
public suspend fun dataProduct(name: String, block: suspend DataProductResourceBuilder.() -> Unit): DataProduct {
    val builder = DataProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataProduct].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataProduct(name: String): DataProduct {
    val builder = DataProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
