@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.DataProductNetworkAclsArgs.builder
import com.pulumi.azurenative.networkanalytics.kotlin.enums.DefaultAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data Product Network rule set
 * @property allowedQueryIpRangeList The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
 * @property defaultAction Default Action
 * @property ipRules IP rule with specific IP or IP range in CIDR format.
 * @property virtualNetworkRule Virtual Network Rule
 */
public data class DataProductNetworkAclsArgs(
    public val allowedQueryIpRangeList: Output<List<String>>,
    public val defaultAction: Output<Either<String, DefaultAction>>,
    public val ipRules: Output<List<IPRulesArgs>>,
    public val virtualNetworkRule: Output<List<VirtualNetworkRuleArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.DataProductNetworkAclsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.DataProductNetworkAclsArgs =
        com.pulumi.azurenative.networkanalytics.inputs.DataProductNetworkAclsArgs.builder()
            .allowedQueryIpRangeList(
                allowedQueryIpRangeList.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .defaultAction(
                defaultAction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkRule(
                virtualNetworkRule.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataProductNetworkAclsArgs].
 */
@PulumiTagMarker
public class DataProductNetworkAclsArgsBuilder internal constructor() {
    private var allowedQueryIpRangeList: Output<List<String>>? = null

    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipRules: Output<List<IPRulesArgs>>? = null

    private var virtualNetworkRule: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
     */
    @JvmName("skvmcvovyjtapmak")
    public suspend fun allowedQueryIpRangeList(`value`: Output<List<String>>) {
        this.allowedQueryIpRangeList = value
    }

    @JvmName("fsbbxipsqahqcsjg")
    public suspend fun allowedQueryIpRangeList(vararg values: Output<String>) {
        this.allowedQueryIpRangeList = Output.all(values.asList())
    }

    /**
     * @param values The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
     */
    @JvmName("bmolaheoycqiskas")
    public suspend fun allowedQueryIpRangeList(values: List<Output<String>>) {
        this.allowedQueryIpRangeList = Output.all(values)
    }

    /**
     * @param value Default Action
     */
    @JvmName("wjtlkwfltcvyxhpk")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("dymfyyhlqfueenca")
    public suspend fun ipRules(`value`: Output<List<IPRulesArgs>>) {
        this.ipRules = value
    }

    @JvmName("bipsuolbtnanilnc")
    public suspend fun ipRules(vararg values: Output<IPRulesArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("dotilwsussinacnq")
    public suspend fun ipRules(values: List<Output<IPRulesArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value Virtual Network Rule
     */
    @JvmName("achcwcfbwmaawgjc")
    public suspend fun virtualNetworkRule(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRule = value
    }

    @JvmName("qthgerosddjvypmv")
    public suspend fun virtualNetworkRule(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRule = Output.all(values.asList())
    }

    /**
     * @param values Virtual Network Rule
     */
    @JvmName("tsaboteiymkarsvg")
    public suspend fun virtualNetworkRule(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRule = Output.all(values)
    }

    /**
     * @param value The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
     */
    @JvmName("swikteqgdlkhbhmp")
    public suspend fun allowedQueryIpRangeList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedQueryIpRangeList = mapped
    }

    /**
     * @param values The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
     */
    @JvmName("mylhxhwleekxfaya")
    public suspend fun allowedQueryIpRangeList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedQueryIpRangeList = mapped
    }

    /**
     * @param value Default Action
     */
    @JvmName("ovulpihdahndapxg")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action
     */
    @JvmName("wceksvhiycjubolj")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action
     */
    @JvmName("folcxylsjeyehoyo")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("gelxrjvpwnvgsbeh")
    public suspend fun ipRules(`value`: List<IPRulesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("eullgjwgmgnhbqvr")
    public suspend fun ipRules(argument: List<suspend IPRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRulesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("tfeijtvngwkdmxsa")
    public suspend fun ipRules(vararg argument: suspend IPRulesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRulesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("edygftbqemcdcmvr")
    public suspend fun ipRules(argument: suspend IPRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRulesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values IP rule with specific IP or IP range in CIDR format.
     */
    @JvmName("tpyshtyyssojmkqm")
    public suspend fun ipRules(vararg values: IPRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value Virtual Network Rule
     */
    @JvmName("ccgdfxjekhuviffs")
    public suspend fun virtualNetworkRule(`value`: List<VirtualNetworkRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRule = mapped
    }

    /**
     * @param argument Virtual Network Rule
     */
    @JvmName("ppysgxsrqyndqxpa")
    public suspend fun virtualNetworkRule(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRule = mapped
    }

    /**
     * @param argument Virtual Network Rule
     */
    @JvmName("hirpxyixfpxaeqmm")
    public suspend fun virtualNetworkRule(vararg argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRule = mapped
    }

    /**
     * @param argument Virtual Network Rule
     */
    @JvmName("qjrbiufpdqkichml")
    public suspend fun virtualNetworkRule(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRule = mapped
    }

    /**
     * @param values Virtual Network Rule
     */
    @JvmName("alftivaeqbdiusep")
    public suspend fun virtualNetworkRule(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRule = mapped
    }

    internal fun build(): DataProductNetworkAclsArgs = DataProductNetworkAclsArgs(
        allowedQueryIpRangeList = allowedQueryIpRangeList ?: throw
            PulumiNullFieldException("allowedQueryIpRangeList"),
        defaultAction = defaultAction ?: throw PulumiNullFieldException("defaultAction"),
        ipRules = ipRules ?: throw PulumiNullFieldException("ipRules"),
        virtualNetworkRule = virtualNetworkRule ?: throw PulumiNullFieldException("virtualNetworkRule"),
    )
}
