@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption key details.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The Uri of the key vault.
 * @property keyVersion The version of the key vault key.
 */
public data class EncryptionKeyDetailsResponse(
    public val keyName: String,
    public val keyVaultUri: String,
    public val keyVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.EncryptionKeyDetailsResponse): EncryptionKeyDetailsResponse = EncryptionKeyDetailsResponse(
            keyName = javaType.keyName(),
            keyVaultUri = javaType.keyVaultUri(),
            keyVersion = javaType.keyVersion(),
        )
    }
}
