@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The data type resource.
 * @property databaseCacheRetention Field for database cache retention in days.
 * @property databaseRetention Field for database data retention in days.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Latest provisioning state  of data product.
 * @property state State of data type.
 * @property stateReason Reason for the state of data type.
 * @property storageOutputRetention Field for storage output retention in days.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property visualizationUrl Url for data visualization.
 */
public data class GetDataTypeResult(
    public val databaseCacheRetention: Int? = null,
    public val databaseRetention: Int? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val state: String? = null,
    public val stateReason: String,
    public val storageOutputRetention: Int? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val visualizationUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.GetDataTypeResult): GetDataTypeResult = GetDataTypeResult(
            databaseCacheRetention = javaType.databaseCacheRetention().map({ args0 -> args0 }).orElse(null),
            databaseRetention = javaType.databaseRetention().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            stateReason = javaType.stateReason(),
            storageOutputRetention = javaType.storageOutputRetention().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            visualizationUrl = javaType.visualizationUrl(),
        )
    }
}
