@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * list role assignments.
 * @property count Count of role assignments.
 * @property roleAssignmentResponse list of role assignments
 */
public data class ListDataProductRolesAssignmentsResult(
    public val count: Int,
    public val roleAssignmentResponse: List<RoleAssignmentDetailResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.ListDataProductRolesAssignmentsResult): ListDataProductRolesAssignmentsResult = ListDataProductRolesAssignmentsResult(
            count = javaType.count(),
            roleAssignmentResponse = javaType.roleAssignmentResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.RoleAssignmentDetailResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
