@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.AgentPoolArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.AgentPoolMode
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AgentOptionsArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AgentOptionsArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AgentPoolUpgradeSettingsArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AgentPoolUpgradeSettingsArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AttachedNetworkConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AttachedNetworkConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.KubernetesLabelArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.KubernetesLabelArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-10-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update Kubernetes cluster agent pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.NetworkCloud.AgentPool("agentPool", new()
 *     {
 *         AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *         {
 *             AdminUsername = "azure",
 *             SshPublicKeys = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *         AgentOptions = new AzureNative.NetworkCloud.Inputs.AgentOptionsArgs
 *         {
 *             HugepagesCount = 96,
 *             HugepagesSize = AzureNative.NetworkCloud.HugepagesSize.HugepagesSize_1G,
 *         },
 *         AgentPoolName = "agentPoolName",
 *         AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *         {
 *             L2Networks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                 {
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.DPDK,
 *                 },
 *             },
 *             L3Networks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                 {
 *                     IpamEnabled = AzureNative.NetworkCloud.L3NetworkConfigurationIpamEnabled.False,
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.SRIOV,
 *                 },
 *             },
 *             TrunkedNetworks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                 {
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.MACVLAN,
 *                 },
 *             },
 *         },
 *         AvailabilityZones = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         Count = 3,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         KubernetesClusterName = "kubernetesClusterName",
 *         Labels = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *             {
 *                 Key = "kubernetes.label",
 *                 Value = "true",
 *             },
 *         },
 *         Location = "location",
 *         Mode = AzureNative.NetworkCloud.AgentPoolMode.System,
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         Taints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *             {
 *                 Key = "kubernetes.taint",
 *                 Value = "true",
 *             },
 *         },
 *         UpgradeSettings = new AzureNative.NetworkCloud.Inputs.AgentPoolUpgradeSettingsArgs
 *         {
 *             MaxSurge = "1",
 *         },
 *         VmSkuName = "NC_M16_v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewAgentPool(ctx, "agentPool", &networkcloud.AgentPoolArgs{
 * 			AdministratorConfiguration: &networkcloud.AdministratorConfigurationArgs{
 * 				AdminUsername: pulumi.String("azure"),
 * 				SshPublicKeys: networkcloud.SshPublicKeyArray{
 * 					&networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 				},
 * 			},
 * 			AgentOptions: &networkcloud.AgentOptionsArgs{
 * 				HugepagesCount: pulumi.Float64(96),
 * 				HugepagesSize:  pulumi.String(networkcloud.HugepagesSize_1G),
 * 			},
 * 			AgentPoolName: pulumi.String("agentPoolName"),
 * 			AttachedNetworkConfiguration: &networkcloud.AttachedNetworkConfigurationArgs{
 * 				L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * 					&networkcloud.L2NetworkAttachmentConfigurationArgs{
 * 						NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * 						PluginType: pulumi.String(networkcloud.KubernetesPluginTypeDPDK),
 * 					},
 * 				},
 * 				L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * 					&networkcloud.L3NetworkAttachmentConfigurationArgs{
 * 						IpamEnabled: pulumi.String(networkcloud.L3NetworkConfigurationIpamEnabledFalse),
 * 						NetworkId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 						PluginType:  pulumi.String(networkcloud.KubernetesPluginTypeSRIOV),
 * 					},
 * 				},
 * 				TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * 					&networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * 						NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * 						PluginType: pulumi.String(networkcloud.KubernetesPluginTypeMACVLAN),
 * 					},
 * 				},
 * 			},
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			Count: pulumi.Float64(3),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			KubernetesClusterName: pulumi.String("kubernetesClusterName"),
 * 			Labels: networkcloud.KubernetesLabelArray{
 * 				&networkcloud.KubernetesLabelArgs{
 * 					Key:   pulumi.String("kubernetes.label"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			Mode:              pulumi.String(networkcloud.AgentPoolModeSystem),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			Taints: networkcloud.KubernetesLabelArray{
 * 				&networkcloud.KubernetesLabelArgs{
 * 					Key:   pulumi.String("kubernetes.taint"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 			UpgradeSettings: &networkcloud.AgentPoolUpgradeSettingsArgs{
 * 				MaxSurge: pulumi.String("1"),
 * 			},
 * 			VmSkuName: pulumi.String("NC_M16_v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.AgentPool;
 * import com.pulumi.azurenative.networkcloud.AgentPoolArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.KubernetesLabelArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .administratorConfiguration(AdministratorConfigurationArgs.builder()
 *                 .adminUsername("azure")
 *                 .sshPublicKeys(SshPublicKeyArgs.builder()
 *                     .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                     .build())
 *                 .build())
 *             .agentOptions(AgentOptionsArgs.builder()
 *                 .hugepagesCount(96)
 *                 .hugepagesSize("1G")
 *                 .build())
 *             .agentPoolName("agentPoolName")
 *             .attachedNetworkConfiguration(AttachedNetworkConfigurationArgs.builder()
 *                 .l2Networks(L2NetworkAttachmentConfigurationArgs.builder()
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName")
 *                     .pluginType("DPDK")
 *                     .build())
 *                 .l3Networks(L3NetworkAttachmentConfigurationArgs.builder()
 *                     .ipamEnabled("False")
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *                     .pluginType("SRIOV")
 *                     .build())
 *                 .trunkedNetworks(TrunkedNetworkAttachmentConfigurationArgs.builder()
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName")
 *                     .pluginType("MACVLAN")
 *                     .build())
 *                 .build())
 *             .availabilityZones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .count(3)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .kubernetesClusterName("kubernetesClusterName")
 *             .labels(KubernetesLabelArgs.builder()
 *                 .key("kubernetes.label")
 *                 .value("true")
 *                 .build())
 *             .location("location")
 *             .mode("System")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .taints(KubernetesLabelArgs.builder()
 *                 .key("kubernetes.taint")
 *                 .value("true")
 *                 .build())
 *             .upgradeSettings(AgentPoolUpgradeSettingsArgs.builder()
 *                 .maxSurge("1")
 *                 .build())
 *             .vmSkuName("NC_M16_v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:AgentPool default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}
 * ```
 * @property administratorConfiguration The administrator credentials to be used for the nodes in this agent pool.
 * @property agentOptions The configurations that will be applied to each agent in this agent pool.
 * @property agentPoolName The name of the Kubernetes cluster agent pool.
 * @property attachedNetworkConfiguration The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property kubernetesClusterName The name of the Kubernetes cluster.
 * @property labels The labels applied to the nodes in this agent pool.
 * @property location The geo-location where the resource lives
 * @property mode The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property taints The taints applied to the nodes in this agent pool.
 * @property upgradeSettings The configuration of the agent pool.
 * @property vmSkuName The name of the VM SKU that determines the size of resources allocated for node VMs.
 */
public data class AgentPoolArgs(
    public val administratorConfiguration: Output<AdministratorConfigurationArgs>? = null,
    public val agentOptions: Output<AgentOptionsArgs>? = null,
    public val agentPoolName: Output<String>? = null,
    public val attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val count: Output<Double>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val kubernetesClusterName: Output<String>? = null,
    public val labels: Output<List<KubernetesLabelArgs>>? = null,
    public val location: Output<String>? = null,
    public val mode: Output<Either<String, AgentPoolMode>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taints: Output<List<KubernetesLabelArgs>>? = null,
    public val upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null,
    public val vmSkuName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.AgentPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.AgentPoolArgs =
        com.pulumi.azurenative.networkcloud.AgentPoolArgs.builder()
            .administratorConfiguration(
                administratorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentOptions(agentOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .attachedNetworkConfiguration(
                attachedNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .count(count?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kubernetesClusterName(kubernetesClusterName?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taints(taints?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .upgradeSettings(upgradeSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSkuName(vmSkuName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolArgs].
 */
@PulumiTagMarker
public class AgentPoolArgsBuilder internal constructor() {
    private var administratorConfiguration: Output<AdministratorConfigurationArgs>? = null

    private var agentOptions: Output<AgentOptionsArgs>? = null

    private var agentPoolName: Output<String>? = null

    private var attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var count: Output<Double>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var kubernetesClusterName: Output<String>? = null

    private var labels: Output<List<KubernetesLabelArgs>>? = null

    private var location: Output<String>? = null

    private var mode: Output<Either<String, AgentPoolMode>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taints: Output<List<KubernetesLabelArgs>>? = null

    private var upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null

    private var vmSkuName: Output<String>? = null

    /**
     * @param value The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("drtkctrxvrgttxdf")
    public suspend fun administratorConfiguration(`value`: Output<AdministratorConfigurationArgs>) {
        this.administratorConfiguration = value
    }

    /**
     * @param value The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("brtuiwsukcntjfgv")
    public suspend fun agentOptions(`value`: Output<AgentOptionsArgs>) {
        this.agentOptions = value
    }

    /**
     * @param value The name of the Kubernetes cluster agent pool.
     */
    @JvmName("ifwouuuaaxrdswea")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("wmphibhtyukopamk")
    public suspend fun attachedNetworkConfiguration(`value`: Output<AttachedNetworkConfigurationArgs>) {
        this.attachedNetworkConfiguration = value
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("jgeomfhvtjqdircc")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("fsucmlpnriehqyke")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("spwisdeinilvpvpx")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("gtlmovdmcltbnnrv")
    public suspend fun count(`value`: Output<Double>) {
        this.count = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("ogvbpvcyrluvptgw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("dsqqrcmqjjgfibul")
    public suspend fun kubernetesClusterName(`value`: Output<String>) {
        this.kubernetesClusterName = value
    }

    /**
     * @param value The labels applied to the nodes in this agent pool.
     */
    @JvmName("rmbgossydbbmqlql")
    public suspend fun labels(`value`: Output<List<KubernetesLabelArgs>>) {
        this.labels = value
    }

    @JvmName("wdewyomrxnwvervn")
    public suspend fun labels(vararg values: Output<KubernetesLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The labels applied to the nodes in this agent pool.
     */
    @JvmName("qwrodiyqlmynnwat")
    public suspend fun labels(values: List<Output<KubernetesLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cgairpagujwcosma")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("bedqtevfwwojjifb")
    public suspend fun mode(`value`: Output<Either<String, AgentPoolMode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lesdaesdgaboiavv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jbvkbslxighsgqxp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The taints applied to the nodes in this agent pool.
     */
    @JvmName("tvptavvpedkvolsk")
    public suspend fun taints(`value`: Output<List<KubernetesLabelArgs>>) {
        this.taints = value
    }

    @JvmName("xygmacgwnnatuucy")
    public suspend fun taints(vararg values: Output<KubernetesLabelArgs>) {
        this.taints = Output.all(values.asList())
    }

    /**
     * @param values The taints applied to the nodes in this agent pool.
     */
    @JvmName("oniimgeiqqbrehmg")
    public suspend fun taints(values: List<Output<KubernetesLabelArgs>>) {
        this.taints = Output.all(values)
    }

    /**
     * @param value The configuration of the agent pool.
     */
    @JvmName("iywsucwpqvtukruq")
    public suspend fun upgradeSettings(`value`: Output<AgentPoolUpgradeSettingsArgs>) {
        this.upgradeSettings = value
    }

    /**
     * @param value The name of the VM SKU that determines the size of resources allocated for node VMs.
     */
    @JvmName("gddasqvokhhbjqkw")
    public suspend fun vmSkuName(`value`: Output<String>) {
        this.vmSkuName = value
    }

    /**
     * @param value The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("mxnvfkoksrbwmuly")
    public suspend fun administratorConfiguration(`value`: AdministratorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorConfiguration = mapped
    }

    /**
     * @param argument The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("jcyvjeiebmirojdt")
    public suspend fun administratorConfiguration(argument: suspend AdministratorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AdministratorConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorConfiguration = mapped
    }

    /**
     * @param value The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("slldajcatvnpkygk")
    public suspend fun agentOptions(`value`: AgentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentOptions = mapped
    }

    /**
     * @param argument The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("dcvffxnqcfxugyck")
    public suspend fun agentOptions(argument: suspend AgentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentOptions = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster agent pool.
     */
    @JvmName("ombqvsxemriaimln")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("wnrjweajnlhsrkol")
    public suspend fun attachedNetworkConfiguration(`value`: AttachedNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param argument The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("ddwmvalnaupbhmmf")
    public suspend fun attachedNetworkConfiguration(argument: suspend AttachedNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AttachedNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("qgmccwathxojlxnn")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("tyqwqlgognrfqkuv")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("vtfgdnhqqcoopvrf")
    public suspend fun count(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("ojkhnsxshusrnbht")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("yjbthnaxmkbiirbv")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("mvpobvqbibqrdkmh")
    public suspend fun kubernetesClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesClusterName = mapped
    }

    /**
     * @param value The labels applied to the nodes in this agent pool.
     */
    @JvmName("tgsdibdaapqusggn")
    public suspend fun labels(`value`: List<KubernetesLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("pqcfvldbphhrtryp")
    public suspend fun labels(argument: List<suspend KubernetesLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("cneygpdjnhokcwrm")
    public suspend fun labels(vararg argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("jwotorjqidfdhysj")
    public suspend fun labels(argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values The labels applied to the nodes in this agent pool.
     */
    @JvmName("wwotlewakgfwloeb")
    public suspend fun labels(vararg values: KubernetesLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gthridmonbhhfhbi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("crjwsxxndomsuqoo")
    public suspend fun mode(`value`: Either<String, AgentPoolMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("bcskubgvriksadbg")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("cohhkhgyagidddgy")
    public fun mode(`value`: AgentPoolMode) {
        val toBeMapped = Either.ofRight<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgthpaxiudakxmwl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("deynttsviykmtvrx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("niyjaypbdhtnyoet")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The taints applied to the nodes in this agent pool.
     */
    @JvmName("mslyvydraegbnqlk")
    public suspend fun taints(`value`: List<KubernetesLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("dcsrdjgnmtgqmqga")
    public suspend fun taints(argument: List<suspend KubernetesLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("eolemnuhuurtpluv")
    public suspend fun taints(vararg argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("lkcelvqeecgsmxwd")
    public suspend fun taints(argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param values The taints applied to the nodes in this agent pool.
     */
    @JvmName("jnatrryapsiuggif")
    public suspend fun taints(vararg values: KubernetesLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param value The configuration of the agent pool.
     */
    @JvmName("txviddibpdxlgyag")
    public suspend fun upgradeSettings(`value`: AgentPoolUpgradeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeSettings = mapped
    }

    /**
     * @param argument The configuration of the agent pool.
     */
    @JvmName("wabjdgnnrrhpqbdl")
    public suspend fun upgradeSettings(argument: suspend AgentPoolUpgradeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolUpgradeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradeSettings = mapped
    }

    /**
     * @param value The name of the VM SKU that determines the size of resources allocated for node VMs.
     */
    @JvmName("yobnvhoafdsoqnjx")
    public suspend fun vmSkuName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSkuName = mapped
    }

    internal fun build(): AgentPoolArgs = AgentPoolArgs(
        administratorConfiguration = administratorConfiguration,
        agentOptions = agentOptions,
        agentPoolName = agentPoolName,
        attachedNetworkConfiguration = attachedNetworkConfiguration,
        availabilityZones = availabilityZones,
        count = count,
        extendedLocation = extendedLocation,
        kubernetesClusterName = kubernetesClusterName,
        labels = labels,
        location = location,
        mode = mode,
        resourceGroupName = resourceGroupName,
        tags = tags,
        taints = taints,
        upgradeSettings = upgradeSettings,
        vmSkuName = vmSkuName,
    )
}
