@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.BareMetalMachineArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministrativeCredentialsArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministrativeCredentialsArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-10-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update bare metal machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bareMetalMachine = new AzureNative.NetworkCloud.BareMetalMachine("bareMetalMachine", new()
 *     {
 *         BareMetalMachineName = "bareMetalMachineName",
 *         BmcConnectionString = "bmcconnectionstring",
 *         BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *         {
 *             Password = "{password}",
 *             Username = "bmcuser",
 *         },
 *         BmcMacAddress = "00:00:4f:00:57:00",
 *         BootMacAddress = "00:00:4e:00:58:af",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MachineDetails = "User-provided machine details.",
 *         MachineName = "r01c001",
 *         MachineSkuId = "684E-3B16-399E",
 *         RackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *         RackSlot = 1,
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "BM1219XXX",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewBareMetalMachine(ctx, "bareMetalMachine", &networkcloud.BareMetalMachineArgs{
 * 			BareMetalMachineName: pulumi.String("bareMetalMachineName"),
 * 			BmcConnectionString:  pulumi.String("bmcconnectionstring"),
 * 			BmcCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * 				Password: pulumi.String("{password}"),
 * 				Username: pulumi.String("bmcuser"),
 * 			},
 * 			BmcMacAddress:  pulumi.String("00:00:4f:00:57:00"),
 * 			BootMacAddress: pulumi.String("00:00:4e:00:58:af"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			MachineDetails:    pulumi.String("User-provided machine details."),
 * 			MachineName:       pulumi.String("r01c001"),
 * 			MachineSkuId:      pulumi.String("684E-3B16-399E"),
 * 			RackId:            pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 			RackSlot:          pulumi.Float64(1),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SerialNumber:      pulumi.String("BM1219XXX"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachine;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bareMetalMachine = new BareMetalMachine("bareMetalMachine", BareMetalMachineArgs.builder()
 *             .bareMetalMachineName("bareMetalMachineName")
 *             .bmcConnectionString("bmcconnectionstring")
 *             .bmcCredentials(AdministrativeCredentialsArgs.builder()
 *                 .password("{password}")
 *                 .username("bmcuser")
 *                 .build())
 *             .bmcMacAddress("00:00:4f:00:57:00")
 *             .bootMacAddress("00:00:4e:00:58:af")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .machineDetails("User-provided machine details.")
 *             .machineName("r01c001")
 *             .machineSkuId("684E-3B16-399E")
 *             .rackId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName")
 *             .rackSlot(1)
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("BM1219XXX")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:BareMetalMachine bareMetalMachineName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}
 * ```
 * @property bareMetalMachineName The name of the bare metal machine.
 * @property bmcConnectionString The connection string for the baseboard management controller including IP address and protocol.
 * @property bmcCredentials The credentials of the baseboard management controller on this bare metal machine.
 * @property bmcMacAddress The MAC address of the BMC device.
 * @property bootMacAddress The MAC address of a NIC connected to the PXE network.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property machineDetails The custom details provided by the customer.
 * @property machineName The OS-level hostname assigned to this machine.
 * @property machineSkuId The unique internal identifier of the bare metal machine SKU.
 * @property rackId The resource ID of the rack where this bare metal machine resides.
 * @property rackSlot The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serialNumber The serial number of the bare metal machine.
 * @property tags Resource tags.
 */
public data class BareMetalMachineArgs(
    public val bareMetalMachineName: Output<String>? = null,
    public val bmcConnectionString: Output<String>? = null,
    public val bmcCredentials: Output<AdministrativeCredentialsArgs>? = null,
    public val bmcMacAddress: Output<String>? = null,
    public val bootMacAddress: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val machineDetails: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val machineSkuId: Output<String>? = null,
    public val rackId: Output<String>? = null,
    public val rackSlot: Output<Double>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.BareMetalMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.BareMetalMachineArgs =
        com.pulumi.azurenative.networkcloud.BareMetalMachineArgs.builder()
            .bareMetalMachineName(bareMetalMachineName?.applyValue({ args0 -> args0 }))
            .bmcConnectionString(bmcConnectionString?.applyValue({ args0 -> args0 }))
            .bmcCredentials(bmcCredentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bmcMacAddress(bmcMacAddress?.applyValue({ args0 -> args0 }))
            .bootMacAddress(bootMacAddress?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .machineDetails(machineDetails?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .machineSkuId(machineSkuId?.applyValue({ args0 -> args0 }))
            .rackId(rackId?.applyValue({ args0 -> args0 }))
            .rackSlot(rackSlot?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BareMetalMachineArgs].
 */
@PulumiTagMarker
public class BareMetalMachineArgsBuilder internal constructor() {
    private var bareMetalMachineName: Output<String>? = null

    private var bmcConnectionString: Output<String>? = null

    private var bmcCredentials: Output<AdministrativeCredentialsArgs>? = null

    private var bmcMacAddress: Output<String>? = null

    private var bootMacAddress: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var machineDetails: Output<String>? = null

    private var machineName: Output<String>? = null

    private var machineSkuId: Output<String>? = null

    private var rackId: Output<String>? = null

    private var rackSlot: Output<Double>? = null

    private var resourceGroupName: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the bare metal machine.
     */
    @JvmName("yapletvximdsceoi")
    public suspend fun bareMetalMachineName(`value`: Output<String>) {
        this.bareMetalMachineName = value
    }

    /**
     * @param value The connection string for the baseboard management controller including IP address and protocol.
     */
    @JvmName("hvrijxharbogkhrx")
    public suspend fun bmcConnectionString(`value`: Output<String>) {
        this.bmcConnectionString = value
    }

    /**
     * @param value The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("rtuvlrlebewbrfcx")
    public suspend fun bmcCredentials(`value`: Output<AdministrativeCredentialsArgs>) {
        this.bmcCredentials = value
    }

    /**
     * @param value The MAC address of the BMC device.
     */
    @JvmName("kntbkibbirnsepxa")
    public suspend fun bmcMacAddress(`value`: Output<String>) {
        this.bmcMacAddress = value
    }

    /**
     * @param value The MAC address of a NIC connected to the PXE network.
     */
    @JvmName("fwcgetdlhnifrcgn")
    public suspend fun bootMacAddress(`value`: Output<String>) {
        this.bootMacAddress = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("jouqlxyxevqlelwq")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ovtgksrgxliraywf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The custom details provided by the customer.
     */
    @JvmName("kwbjbnnxdxmxvryp")
    public suspend fun machineDetails(`value`: Output<String>) {
        this.machineDetails = value
    }

    /**
     * @param value The OS-level hostname assigned to this machine.
     */
    @JvmName("vixkffvqglblcfdk")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The unique internal identifier of the bare metal machine SKU.
     */
    @JvmName("omdftsyeyycwgxlv")
    public suspend fun machineSkuId(`value`: Output<String>) {
        this.machineSkuId = value
    }

    /**
     * @param value The resource ID of the rack where this bare metal machine resides.
     */
    @JvmName("fbaivsqwcodalitg")
    public suspend fun rackId(`value`: Output<String>) {
        this.rackId = value
    }

    /**
     * @param value The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1.
     */
    @JvmName("qfuailflesghoxrl")
    public suspend fun rackSlot(`value`: Output<Double>) {
        this.rackSlot = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("frynwwlwnegycvyk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The serial number of the bare metal machine.
     */
    @JvmName("ctiselgvvaisdtnd")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ymmvyqqxvwkfaudd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the bare metal machine.
     */
    @JvmName("ubikfyoovtavcipr")
    public suspend fun bareMetalMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetalMachineName = mapped
    }

    /**
     * @param value The connection string for the baseboard management controller including IP address and protocol.
     */
    @JvmName("qryyadpjlskmjvoq")
    public suspend fun bmcConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bmcConnectionString = mapped
    }

    /**
     * @param value The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("wpamipcpxygmqatx")
    public suspend fun bmcCredentials(`value`: AdministrativeCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bmcCredentials = mapped
    }

    /**
     * @param argument The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("hquoxevcdwsdtkfi")
    public suspend fun bmcCredentials(argument: suspend AdministrativeCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AdministrativeCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bmcCredentials = mapped
    }

    /**
     * @param value The MAC address of the BMC device.
     */
    @JvmName("mjjsdauaguwmwaum")
    public suspend fun bmcMacAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bmcMacAddress = mapped
    }

    /**
     * @param value The MAC address of a NIC connected to the PXE network.
     */
    @JvmName("hdjjdurkdkfqkosa")
    public suspend fun bootMacAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootMacAddress = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("lgcdeqkptdhqamhe")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("imjgxolgyqspmfkt")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("odugqfmeqvhxvcmf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The custom details provided by the customer.
     */
    @JvmName("ljwyvwmujatdamap")
    public suspend fun machineDetails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineDetails = mapped
    }

    /**
     * @param value The OS-level hostname assigned to this machine.
     */
    @JvmName("egarysawaehfeoje")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The unique internal identifier of the bare metal machine SKU.
     */
    @JvmName("rcclutburmyjmmxk")
    public suspend fun machineSkuId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineSkuId = mapped
    }

    /**
     * @param value The resource ID of the rack where this bare metal machine resides.
     */
    @JvmName("hcwyildhdtwtjube")
    public suspend fun rackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackId = mapped
    }

    /**
     * @param value The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1.
     */
    @JvmName("nhsgomtmopkyqnre")
    public suspend fun rackSlot(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackSlot = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rlwrwdhdtvukofws")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The serial number of the bare metal machine.
     */
    @JvmName("fsrvqoftnjskwugv")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qaahyvvjmcnmhluo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sastmyyiugcnyegf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BareMetalMachineArgs = BareMetalMachineArgs(
        bareMetalMachineName = bareMetalMachineName,
        bmcConnectionString = bmcConnectionString,
        bmcCredentials = bmcCredentials,
        bmcMacAddress = bmcMacAddress,
        bootMacAddress = bootMacAddress,
        extendedLocation = extendedLocation,
        location = location,
        machineDetails = machineDetails,
        machineName = machineName,
        machineSkuId = machineSkuId,
        rackId = rackId,
        rackSlot = rackSlot,
        resourceGroupName = resourceGroupName,
        serialNumber = serialNumber,
        tags = tags,
    )
}
