@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserStatusResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserResponse.Companion.toKotlin as keySetUserResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserStatusResponse.Companion.toKotlin as keySetUserStatusResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BareMetalMachineKeySet].
 */
@PulumiTagMarker
public class BareMetalMachineKeySetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BareMetalMachineKeySetArgs = BareMetalMachineKeySetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BareMetalMachineKeySetArgsBuilder.() -> Unit) {
        val builder = BareMetalMachineKeySetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BareMetalMachineKeySet {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BareMetalMachineKeySet(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-10-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update bare metal machine key set of cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bareMetalMachineKeySet = new AzureNative.NetworkCloud.BareMetalMachineKeySet("bareMetalMachineKeySet", new()
 *     {
 *         AzureGroupId = "f110271b-XXXX-4163-9b99-214d91660f0e",
 *         BareMetalMachineKeySetName = "bareMetalMachineKeySetName",
 *         ClusterName = "clusterName",
 *         Expiration = "2022-12-31T23:59:59.008Z",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         JumpHostsAllowed = new[]
 *         {
 *             "192.0.2.1",
 *             "192.0.2.5",
 *         },
 *         Location = "location",
 *         OsGroupName = "standardAccessGroup",
 *         PrivilegeLevel = AzureNative.NetworkCloud.BareMetalMachineKeySetPrivilegeLevel.Standard,
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         UserList = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userABC",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *                 UserPrincipalName = "userABC@contoso.com",
 *             },
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userXYZ",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *                 UserPrincipalName = "userABC@contoso.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewBareMetalMachineKeySet(ctx, "bareMetalMachineKeySet", &networkcloud.BareMetalMachineKeySetArgs{
 * 			AzureGroupId:               pulumi.String("f110271b-XXXX-4163-9b99-214d91660f0e"),
 * 			BareMetalMachineKeySetName: pulumi.String("bareMetalMachineKeySetName"),
 * 			ClusterName:                pulumi.String("clusterName"),
 * 			Expiration:                 pulumi.String("2022-12-31T23:59:59.008Z"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			JumpHostsAllowed: pulumi.StringArray{
 * 				pulumi.String("192.0.2.1"),
 * 				pulumi.String("192.0.2.5"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			OsGroupName:       pulumi.String("standardAccessGroup"),
 * 			PrivilegeLevel:    pulumi.String(networkcloud.BareMetalMachineKeySetPrivilegeLevelStandard),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			UserList: networkcloud.KeySetUserArray{
 * 				&networkcloud.KeySetUserArgs{
 * 					AzureUserName: pulumi.String("userABC"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 					UserPrincipalName: pulumi.String("userABC@contoso.com"),
 * 				},
 * 				&networkcloud.KeySetUserArgs{
 * 					AzureUserName: pulumi.String("userXYZ"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 					UserPrincipalName: pulumi.String("userABC@contoso.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bareMetalMachineKeySet = new BareMetalMachineKeySet("bareMetalMachineKeySet", BareMetalMachineKeySetArgs.builder()
 *             .azureGroupId("f110271b-XXXX-4163-9b99-214d91660f0e")
 *             .bareMetalMachineKeySetName("bareMetalMachineKeySetName")
 *             .clusterName("clusterName")
 *             .expiration("2022-12-31T23:59:59.008Z")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .jumpHostsAllowed(
 *                 "192.0.2.1",
 *                 "192.0.2.5")
 *             .location("location")
 *             .osGroupName("standardAccessGroup")
 *             .privilegeLevel("Standard")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .userList(
 *                 KeySetUserArgs.builder()
 *                     .azureUserName("userABC")
 *                     .description("Needs access for troubleshooting as a part of the support team")
 *                     .sshPublicKey(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .userPrincipalName("userABC@contoso.com")
 *                     .build(),
 *                 KeySetUserArgs.builder()
 *                     .azureUserName("userXYZ")
 *                     .description("Needs access for troubleshooting as a part of the support team")
 *                     .sshPublicKey(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .userPrincipalName("userABC@contoso.com")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:BareMetalMachineKeySet bareMetalMachineKeySetName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}
 * ```
 */
public class BareMetalMachineKeySet internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet,
) : KotlinCustomResource(javaResource, BareMetalMachineKeySetMapper) {
    /**
     * The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
     */
    public val azureGroupId: Output<String>
        get() = javaResource.azureGroupId().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the key set.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The date and time after which the users in this key set will be removed from the bare metal machines.
     */
    public val expiration: Output<String>
        get() = javaResource.expiration().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
     */
    public val jumpHostsAllowed: Output<List<String>>
        get() = javaResource.jumpHostsAllowed().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The last time this key set was validated.
     */
    public val lastValidation: Output<String>
        get() = javaResource.lastValidation().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the group that users will be assigned to on the operating system of the machines.
     */
    public val osGroupName: Output<String>?
        get() = javaResource.osGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The access level allowed for the users in this key set.
     */
    public val privilegeLevel: Output<String>
        get() = javaResource.privilegeLevel().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the bare metal machine key set.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique list of permitted users.
     */
    public val userList: Output<List<KeySetUserResponse>>
        get() = javaResource.userList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keySetUserResponseToKotlin(args0)
                })
            })
        })

    /**
     * The status evaluation of each user.
     */
    public val userListStatus: Output<List<KeySetUserStatusResponse>>
        get() = javaResource.userListStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keySetUserStatusResponseToKotlin(args0) })
            })
        })
}

public object BareMetalMachineKeySetMapper : ResourceMapper<BareMetalMachineKeySet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet::class == javaResource::class

    override fun map(javaResource: Resource): BareMetalMachineKeySet =
        BareMetalMachineKeySet(
            javaResource as
                com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet,
        )
}

/**
 * @see [BareMetalMachineKeySet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BareMetalMachineKeySet].
 */
public suspend fun bareMetalMachineKeySet(
    name: String,
    block: suspend BareMetalMachineKeySetResourceBuilder.() -> Unit,
): BareMetalMachineKeySet {
    val builder = BareMetalMachineKeySetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BareMetalMachineKeySet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bareMetalMachineKeySet(name: String): BareMetalMachineKeySet {
    val builder = BareMetalMachineKeySetResourceBuilder()
    builder.name(name)
    return builder.build()
}
