@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserStatusResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserResponse.Companion.toKotlin as keySetUserResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserStatusResponse.Companion.toKotlin as keySetUserStatusResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BmcKeySet].
 */
@PulumiTagMarker
public class BmcKeySetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BmcKeySetArgs = BmcKeySetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BmcKeySetArgsBuilder.() -> Unit) {
        val builder = BmcKeySetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BmcKeySet {
        val builtJavaResource = com.pulumi.azurenative.networkcloud.BmcKeySet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BmcKeySet(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-10-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update baseboard management controller key set of cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bmcKeySet = new AzureNative.NetworkCloud.BmcKeySet("bmcKeySet", new()
 *     {
 *         AzureGroupId = "f110271b-XXXX-4163-9b99-214d91660f0e",
 *         BmcKeySetName = "bmcKeySetName",
 *         ClusterName = "clusterName",
 *         Expiration = "2022-12-31T23:59:59.008Z",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         PrivilegeLevel = AzureNative.NetworkCloud.BmcKeySetPrivilegeLevel.Administrator,
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         UserList = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userABC",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *                 UserPrincipalName = "userABC@contoso.com",
 *             },
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userXYZ",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *                 UserPrincipalName = "userABC@contoso.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewBmcKeySet(ctx, "bmcKeySet", &networkcloud.BmcKeySetArgs{
 * 			AzureGroupId:  pulumi.String("f110271b-XXXX-4163-9b99-214d91660f0e"),
 * 			BmcKeySetName: pulumi.String("bmcKeySetName"),
 * 			ClusterName:   pulumi.String("clusterName"),
 * 			Expiration:    pulumi.String("2022-12-31T23:59:59.008Z"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			PrivilegeLevel:    pulumi.String(networkcloud.BmcKeySetPrivilegeLevelAdministrator),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			UserList: networkcloud.KeySetUserArray{
 * 				&networkcloud.KeySetUserArgs{
 * 					AzureUserName: pulumi.String("userABC"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 					UserPrincipalName: pulumi.String("userABC@contoso.com"),
 * 				},
 * 				&networkcloud.KeySetUserArgs{
 * 					AzureUserName: pulumi.String("userXYZ"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 					UserPrincipalName: pulumi.String("userABC@contoso.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.BmcKeySet;
 * import com.pulumi.azurenative.networkcloud.BmcKeySetArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.KeySetUserArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bmcKeySet = new BmcKeySet("bmcKeySet", BmcKeySetArgs.builder()
 *             .azureGroupId("f110271b-XXXX-4163-9b99-214d91660f0e")
 *             .bmcKeySetName("bmcKeySetName")
 *             .clusterName("clusterName")
 *             .expiration("2022-12-31T23:59:59.008Z")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .privilegeLevel("Administrator")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .userList(
 *                 KeySetUserArgs.builder()
 *                     .azureUserName("userABC")
 *                     .description("Needs access for troubleshooting as a part of the support team")
 *                     .sshPublicKey(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .userPrincipalName("userABC@contoso.com")
 *                     .build(),
 *                 KeySetUserArgs.builder()
 *                     .azureUserName("userXYZ")
 *                     .description("Needs access for troubleshooting as a part of the support team")
 *                     .sshPublicKey(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .userPrincipalName("userABC@contoso.com")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:BmcKeySet bmcKeySetName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bmcKeySets/{bmcKeySetName}
 * ```
 */
public class BmcKeySet internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.BmcKeySet,
) : KotlinCustomResource(javaResource, BmcKeySetMapper) {
    /**
     * The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
     */
    public val azureGroupId: Output<String>
        get() = javaResource.azureGroupId().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the key set.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The date and time after which the users in this key set will be removed from the baseboard management controllers.
     */
    public val expiration: Output<String>
        get() = javaResource.expiration().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The last time this key set was validated.
     */
    public val lastValidation: Output<String>
        get() = javaResource.lastValidation().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The access level allowed for the users in this key set.
     */
    public val privilegeLevel: Output<String>
        get() = javaResource.privilegeLevel().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the baseboard management controller key set.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique list of permitted users.
     */
    public val userList: Output<List<KeySetUserResponse>>
        get() = javaResource.userList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keySetUserResponseToKotlin(args0)
                })
            })
        })

    /**
     * The status evaluation of each user.
     */
    public val userListStatus: Output<List<KeySetUserStatusResponse>>
        get() = javaResource.userListStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keySetUserStatusResponseToKotlin(args0) })
            })
        })
}

public object BmcKeySetMapper : ResourceMapper<BmcKeySet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.BmcKeySet::class == javaResource::class

    override fun map(javaResource: Resource): BmcKeySet = BmcKeySet(
        javaResource as
            com.pulumi.azurenative.networkcloud.BmcKeySet,
    )
}

/**
 * @see [BmcKeySet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BmcKeySet].
 */
public suspend fun bmcKeySet(name: String, block: suspend BmcKeySetResourceBuilder.() -> Unit): BmcKeySet {
    val builder = BmcKeySetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BmcKeySet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bmcKeySet(name: String): BmcKeySet {
    val builder = BmcKeySetResourceBuilder()
    builder.name(name)
    return builder.build()
}
