@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableVersionResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableVersionResponse.Companion.toKotlin as clusterAvailableVersionResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin as managedResourceGroupConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ClusterManager].
 */
@PulumiTagMarker
public class ClusterManagerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterManagerArgs = ClusterManagerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterManagerArgsBuilder.() -> Unit) {
        val builder = ClusterManagerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterManager {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.ClusterManager(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClusterManager(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-10-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update cluster manager
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterManager = new AzureNative.NetworkCloud.ClusterManager("clusterManager", new()
 *     {
 *         AnalyticsWorkspaceId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName",
 *         ClusterManagerName = "clusterManagerName",
 *         FabricControllerId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName",
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewClusterManager(ctx, "clusterManager", &networkcloud.ClusterManagerArgs{
 * 			AnalyticsWorkspaceId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName"),
 * 			ClusterManagerName:   pulumi.String("clusterManagerName"),
 * 			FabricControllerId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName"),
 * 			Location:             pulumi.String("location"),
 * 			ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * 				Location: pulumi.String("East US"),
 * 				Name:     pulumi.String("my-managed-rg"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.ClusterManager;
 * import com.pulumi.azurenative.networkcloud.ClusterManagerArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterManager = new ClusterManager("clusterManager", ClusterManagerArgs.builder()
 *             .analyticsWorkspaceId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName")
 *             .clusterManagerName("clusterManagerName")
 *             .fabricControllerId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName")
 *             .location("location")
 *             .managedResourceGroupConfiguration(ManagedResourceGroupConfigurationArgs.builder()
 *                 .location("East US")
 *                 .name("my-managed-rg")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:ClusterManager clusterManagerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusterManagers/{clusterManagerName}
 * ```
 */
public class ClusterManager internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.ClusterManager,
) : KotlinCustomResource(javaResource, ClusterManagerMapper) {
    /**
     * The resource ID of the Log Analytics workspace that is used for the logs collection.
     */
    public val analyticsWorkspaceId: Output<String>?
        get() = javaResource.analyticsWorkspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The list of the cluster versions the manager supports. It is used as input in clusterVersion property of a cluster resource.
     */
    public val clusterVersions: Output<List<ClusterAvailableVersionResponse>>
        get() = javaResource.clusterVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterAvailableVersionResponseToKotlin(args0) })
            })
        })

    /**
     * The detailed status that provides additional information about the cluster manager.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the fabric controller that has one to one mapping with the cluster manager.
     */
    public val fabricControllerId: Output<String>
        get() = javaResource.fabricControllerId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The configuration of the managed resource group associated with the resource.
     */
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedResourceGroupConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The extended location (custom location) that represents the cluster manager's control plane location. This extended location is used when creating cluster and rack manifest resources.
     */
    public val managerExtendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.managerExtendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the cluster manager.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The size of the Azure virtual machines to use for hosting the cluster manager resource.
     */
    public val vmSize: Output<String>?
        get() = javaResource.vmSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ClusterManagerMapper : ResourceMapper<ClusterManager> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.ClusterManager::class == javaResource::class

    override fun map(javaResource: Resource): ClusterManager = ClusterManager(
        javaResource as
            com.pulumi.azurenative.networkcloud.ClusterManager,
    )
}

/**
 * @see [ClusterManager].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterManager].
 */
public suspend fun clusterManager(
    name: String,
    block: suspend ClusterManagerResourceBuilder.() -> Unit,
): ClusterManager {
    val builder = ClusterManagerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterManager].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterManager(name: String): ClusterManager {
    val builder = ClusterManagerResourceBuilder()
    builder.name(name)
    return builder.build()
}
