@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.L3NetworkArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.HybridAksIpamEnabled
import com.pulumi.azurenative.networkcloud.kotlin.enums.HybridAksPluginType
import com.pulumi.azurenative.networkcloud.kotlin.enums.IpAllocationType
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-10-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update L3 network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l3Network = new AzureNative.NetworkCloud.L3Network("l3Network", new()
 *     {
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InterfaceName = "eth0",
 *         IpAllocationType = AzureNative.NetworkCloud.IpAllocationType.DualStack,
 *         Ipv4ConnectedPrefix = "198.51.100.0/24",
 *         Ipv6ConnectedPrefix = "2001:db8::/64",
 *         L3IsolationDomainId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
 *         L3NetworkName = "l3NetworkName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         Vlan = 12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewL3Network(ctx, "l3Network", &networkcloud.L3NetworkArgs{
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InterfaceName:       pulumi.String("eth0"),
 * 			IpAllocationType:    pulumi.String(networkcloud.IpAllocationTypeDualStack),
 * 			Ipv4ConnectedPrefix: pulumi.String("198.51.100.0/24"),
 * 			Ipv6ConnectedPrefix: pulumi.String("2001:db8::/64"),
 * 			L3IsolationDomainId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName"),
 * 			L3NetworkName:       pulumi.String("l3NetworkName"),
 * 			Location:            pulumi.String("location"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			Vlan: pulumi.Float64(12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.L3Network;
 * import com.pulumi.azurenative.networkcloud.L3NetworkArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l3Network = new L3Network("l3Network", L3NetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .interfaceName("eth0")
 *             .ipAllocationType("DualStack")
 *             .ipv4ConnectedPrefix("198.51.100.0/24")
 *             .ipv6ConnectedPrefix("2001:db8::/64")
 *             .l3IsolationDomainId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName")
 *             .l3NetworkName("l3NetworkName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .vlan(12)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:L3Network l3NetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/l3Networks/{l3NetworkName}
 * ```
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksIpamEnabled Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
 * @property hybridAksPluginType Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
 * @property interfaceName The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
 * @property ipAllocationType The type of the IP address allocation, defaulted to "DualStack".
 * @property ipv4ConnectedPrefix The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
 * is IPV4 or DualStack.
 * @property ipv6ConnectedPrefix The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
 * is IPV6 or DualStack.
 * @property l3IsolationDomainId The resource ID of the Network Fabric l3IsolationDomain.
 * @property l3NetworkName The name of the L3 network.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vlan The VLAN from the l3IsolationDomain that is used for this network.
 */
public data class L3NetworkArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hybridAksIpamEnabled: Output<Either<String, HybridAksIpamEnabled>>? = null,
    public val hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null,
    public val interfaceName: Output<String>? = null,
    public val ipAllocationType: Output<Either<String, IpAllocationType>>? = null,
    public val ipv4ConnectedPrefix: Output<String>? = null,
    public val ipv6ConnectedPrefix: Output<String>? = null,
    public val l3IsolationDomainId: Output<String>? = null,
    public val l3NetworkName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlan: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.L3NetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.L3NetworkArgs =
        com.pulumi.azurenative.networkcloud.L3NetworkArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hybridAksIpamEnabled(
                hybridAksIpamEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .hybridAksPluginType(
                hybridAksPluginType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .interfaceName(interfaceName?.applyValue({ args0 -> args0 }))
            .ipAllocationType(
                ipAllocationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipv4ConnectedPrefix(ipv4ConnectedPrefix?.applyValue({ args0 -> args0 }))
            .ipv6ConnectedPrefix(ipv6ConnectedPrefix?.applyValue({ args0 -> args0 }))
            .l3IsolationDomainId(l3IsolationDomainId?.applyValue({ args0 -> args0 }))
            .l3NetworkName(l3NetworkName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L3NetworkArgs].
 */
@PulumiTagMarker
public class L3NetworkArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hybridAksIpamEnabled: Output<Either<String, HybridAksIpamEnabled>>? = null

    private var hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null

    private var interfaceName: Output<String>? = null

    private var ipAllocationType: Output<Either<String, IpAllocationType>>? = null

    private var ipv4ConnectedPrefix: Output<String>? = null

    private var ipv6ConnectedPrefix: Output<String>? = null

    private var l3IsolationDomainId: Output<String>? = null

    private var l3NetworkName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlan: Output<Double>? = null

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("wtonkwojomcjuxxp")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
     */
    @JvmName("wsldmcvkbrvgjtqf")
    public suspend fun hybridAksIpamEnabled(`value`: Output<Either<String, HybridAksIpamEnabled>>) {
        this.hybridAksIpamEnabled = value
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("qjaodgnkeofhqdko")
    public suspend fun hybridAksPluginType(`value`: Output<Either<String, HybridAksPluginType>>) {
        this.hybridAksPluginType = value
    }

    /**
     * @param value The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("yrymdeqbbwpcaqtp")
    public suspend fun interfaceName(`value`: Output<String>) {
        this.interfaceName = value
    }

    /**
     * @param value The type of the IP address allocation, defaulted to "DualStack".
     */
    @JvmName("kxklxepmfoqviatv")
    public suspend fun ipAllocationType(`value`: Output<Either<String, IpAllocationType>>) {
        this.ipAllocationType = value
    }

    /**
     * @param value The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
     * is IPV4 or DualStack.
     */
    @JvmName("jitglhisopbpamvu")
    public suspend fun ipv4ConnectedPrefix(`value`: Output<String>) {
        this.ipv4ConnectedPrefix = value
    }

    /**
     * @param value The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
     * is IPV6 or DualStack.
     */
    @JvmName("rycrystwbhxlfbsd")
    public suspend fun ipv6ConnectedPrefix(`value`: Output<String>) {
        this.ipv6ConnectedPrefix = value
    }

    /**
     * @param value The resource ID of the Network Fabric l3IsolationDomain.
     */
    @JvmName("ovnkmwlyvlnnsuee")
    public suspend fun l3IsolationDomainId(`value`: Output<String>) {
        this.l3IsolationDomainId = value
    }

    /**
     * @param value The name of the L3 network.
     */
    @JvmName("mostkqoflhmylugq")
    public suspend fun l3NetworkName(`value`: Output<String>) {
        this.l3NetworkName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pekdvougbqdomfwi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vivoupyctsugywjd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ofwspwcjyxtrpkrh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN from the l3IsolationDomain that is used for this network.
     */
    @JvmName("tyejcwnvwtkwkiox")
    public suspend fun vlan(`value`: Output<Double>) {
        this.vlan = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("keupqrebucetkdle")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("ddgyhkinccvxjiyc")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
     */
    @JvmName("twjflvrmiusngxgx")
    public suspend fun hybridAksIpamEnabled(`value`: Either<String, HybridAksIpamEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksIpamEnabled = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
     */
    @JvmName("tbxflvguitblklwt")
    public fun hybridAksIpamEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridAksIpamEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksIpamEnabled = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
     */
    @JvmName("wokdfljtaoqsxauk")
    public fun hybridAksIpamEnabled(`value`: HybridAksIpamEnabled) {
        val toBeMapped = Either.ofRight<String, HybridAksIpamEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksIpamEnabled = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("qsgtagarqmqncsjk")
    public suspend fun hybridAksPluginType(`value`: Either<String, HybridAksPluginType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("touwjiabdtmoserk")
    public fun hybridAksPluginType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("aakambwgiwssshqf")
    public fun hybridAksPluginType(`value`: HybridAksPluginType) {
        val toBeMapped = Either.ofRight<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("gbmcfvekcorixgsr")
    public suspend fun interfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceName = mapped
    }

    /**
     * @param value The type of the IP address allocation, defaulted to "DualStack".
     */
    @JvmName("ldbvgpvorywxdydi")
    public suspend fun ipAllocationType(`value`: Either<String, IpAllocationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The type of the IP address allocation, defaulted to "DualStack".
     */
    @JvmName("gdtgaxsmmtcuclni")
    public fun ipAllocationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The type of the IP address allocation, defaulted to "DualStack".
     */
    @JvmName("wmgipxlksqwgscjw")
    public fun ipAllocationType(`value`: IpAllocationType) {
        val toBeMapped = Either.ofRight<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
     * is IPV4 or DualStack.
     */
    @JvmName("wrxipekvwunnblhb")
    public suspend fun ipv4ConnectedPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4ConnectedPrefix = mapped
    }

    /**
     * @param value The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
     * is IPV6 or DualStack.
     */
    @JvmName("htvcmneswtxqdiwu")
    public suspend fun ipv6ConnectedPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6ConnectedPrefix = mapped
    }

    /**
     * @param value The resource ID of the Network Fabric l3IsolationDomain.
     */
    @JvmName("lwdcelfavijgiasw")
    public suspend fun l3IsolationDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3IsolationDomainId = mapped
    }

    /**
     * @param value The name of the L3 network.
     */
    @JvmName("bapbaxkvkrkwpmuk")
    public suspend fun l3NetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3NetworkName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jsedcefblddhfrsi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xnqisoioahigsnrj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("foncsnloeptbttpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cvuspkwbdlxftwyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN from the l3IsolationDomain that is used for this network.
     */
    @JvmName("cnbcttvdimynxfsf")
    public suspend fun vlan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): L3NetworkArgs = L3NetworkArgs(
        extendedLocation = extendedLocation,
        hybridAksIpamEnabled = hybridAksIpamEnabled,
        hybridAksPluginType = hybridAksPluginType,
        interfaceName = interfaceName,
        ipAllocationType = ipAllocationType,
        ipv4ConnectedPrefix = ipv4ConnectedPrefix,
        ipv6ConnectedPrefix = ipv6ConnectedPrefix,
        l3IsolationDomainId = l3IsolationDomainId,
        l3NetworkName = l3NetworkName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vlan = vlan,
    )
}
