@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
 */
public enum class AgentPoolMode(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.AgentPoolMode,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.AgentPoolMode> {
    System(com.pulumi.azurenative.networkcloud.enums.AgentPoolMode.System),
    User(com.pulumi.azurenative.networkcloud.enums.AgentPoolMode.User),
    NotApplicable(com.pulumi.azurenative.networkcloud.enums.AgentPoolMode.NotApplicable),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.AgentPoolMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.AgentPoolMode): AgentPoolMode = AgentPoolMode.values().first { it.javaValue == javaType }
    }
}
