@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
 */
public enum class BfdEnabled(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.BfdEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.BfdEnabled> {
    True(com.pulumi.azurenative.networkcloud.enums.BfdEnabled.True),
    False(com.pulumi.azurenative.networkcloud.enums.BfdEnabled.False),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.BfdEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.BfdEnabled): BfdEnabled = BfdEnabled.values().first { it.javaValue == javaType }
    }
}
