@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
 */
public enum class HybridAksPluginType(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType> {
    DPDK(com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType.DPDK),
    SRIOV(com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType.SRIOV),
    OSDevice(com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType.OSDevice),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.HybridAksPluginType): HybridAksPluginType = HybridAksPluginType.values().first { it.javaValue == javaType }
    }
}
