@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the IP address allocation, defaulted to "DualStack".
 */
public enum class IpAllocationType(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.IpAllocationType,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.IpAllocationType> {
    IPV4(com.pulumi.azurenative.networkcloud.enums.IpAllocationType.IPV4),
    IPV6(com.pulumi.azurenative.networkcloud.enums.IpAllocationType.IPV6),
    DualStack(com.pulumi.azurenative.networkcloud.enums.IpAllocationType.DualStack),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.IpAllocationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.IpAllocationType): IpAllocationType = IpAllocationType.values().first { it.javaValue == javaType }
    }
}
