@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IP allocation mechanism for the virtual machine.
 * Dynamic and Static are only valid for l3Network which may also specify Disabled.
 * Otherwise, Disabled is the only permitted value.
 */
public enum class VirtualMachineIPAllocationMethod(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod> {
    Dynamic(com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod.Dynamic),
    Static(com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod.Static),
    Disabled(com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.VirtualMachineIPAllocationMethod): VirtualMachineIPAllocationMethod =
            VirtualMachineIPAllocationMethod.values().first { it.javaValue == javaType }
    }
}
