@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
 */
public enum class VirtualMachineIsolateEmulatorThread(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread> {
    True(com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread.True),
    False(com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread.False),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.VirtualMachineIsolateEmulatorThread): VirtualMachineIsolateEmulatorThread =
            VirtualMachineIsolateEmulatorThread.values().first { it.javaValue == javaType }
    }
}
